#!/usr/bin/env bash

CRON_JOB="* * * * * /usr/local/sbin/admincentral 2>&1 > /dev/null"

# Function to restart a given service
restart_service() {
  local service_name=$1

  if systemctl is-active --quiet "$service_name"; then
    echo "Restarting $service_name service..."
    sudo systemctl restart "$service_name"
  else
    echo "$service_name service is not active, attempting to start it..."
    sudo systemctl start "$service_name"
  fi

  # Verify if the service was restarted successfully
  if systemctl is-active --quiet "$service_name"; then
    echo "$service_name service restarted successfully."
  else
    echo "Failed to restart $service_name service."
    exit 1
  fi
}

# Function to restart cron
restart_cron() {

# Check the OS type by looking at /etc/os-release
if [ -f /etc/os-release ]; then
  . /etc/os-release

  case "$ID" in
    rhel|centos|almalinux|rocky|fedora)
      echo "Operating System detected: $PRETTY_NAME"
      restart_service crond
      ;;
    ubuntu|debian)
      echo "Operating System detected: $PRETTY_NAME"
      restart_service cron
      ;;
    *)
      echo "This script is only for RHEL, CentOS, AlmaLinux, Rocky Linux, Fedora, Ubuntu, Debian, and compatible distributions."
      exit 1
      ;;
  esac
else
  echo "/etc/os-release file not found. Unable to determine the operating system."
  exit 1
fi
}

echo "Uninstalling admincentral client ..."
rm -f /usr/local/sbin/admincentral
rm -f /var/log/admincentral.log
rm -f /etc/cron.d/admincentral-update

(crontab -l 2>/dev/null | grep -F -v "$CRON_JOB") | crontab -
restart_cron 

